﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="FragLabOrder.aspx.cs" Inherits="FragLabOrder" MasterPageFile ="~/Registry.master" %>
<%@ Register src="~/controls/FromToDate.ascx" tagname="FromToDate" tagprefix="UserControlFromToDate" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href ="styles/StyleSheet.css"/>          
</asp:Content> 
<asp:Content ID="Content2" ContentPlaceHolderID = "ContentPlaceHolder" Runat="Server" >
    <asp:ValidationSummary ID="ValidationSummaryFragLabOrder"  runat="server"
        TabIndex="1" 
        HeaderText="The page has the following data errors:" 
        DisplayMode="BulletList" 
        ShowSummary="false" 
        ValidationGroup="LabOrderValidation"
        ShowMessageBox="True" />
   
    <asp:ObjectDataSource ID="ObjectDataSourceOrderStatus" runat="server" 
            SelectMethod="getOrderStatusByActivityID" 
            TypeName="VeteransAffairs.Registries.BusinessManager.LabOrderManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "activityId" Direction = "Input" Name = "id" /> 
            </SelectParameters>
    </asp:ObjectDataSource> 
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
            SelectMethod="GetPatientByActivityId" 
            TypeName="VeteransAffairs.Registries.BusinessManager.LabOrderManager">
            <SelectParameters>
                <asp:QueryStringParameter QueryStringField = "activityId" Direction = "Input" Name = "id" /> 
            </SelectParameters>       
     </asp:ObjectDataSource>
    <div class="breadcrumb">
        <asp:FormView ID="FormViewBreadCrumb" runat="server" DataSourceID="ObjectDataSourceOrderStatus">
            <ItemTemplate>
              <asp:Label ID = "BreadCrumbLabel" runat="server" Text='<%# "My Tasks > Lab Orders > " + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Name")), false) + " > Workflow ID : " + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CaseId")), false) %>'  SkinID = "DataLabel" />
              <br />
            </ItemTemplate>
        </asp:FormView>
    </div>
    <table>
        <tr>
            <td>
            <asp:FormView ID="FormViewPatientInformation" runat="server"  
            DataSourceID="ObjectDataSourcePatient" Width="100%" DataKeyNames = "PatientId" 
                    CellPadding="4" ForeColor="#333333">
                <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
                <ItemTemplate>
                    
                    <asp:Panel ID="PanelPatient" runat="server" GroupingText="&nbsp;Patient Information&nbsp;" Width = "100%" >
                    <br />
                    <table cellpadding="-1" cellspacing="10" width="100%">
                    <tr style = "width:100%;" >
                        <td align= "left"> 
                         <table border = "0px">
                            <tr style = "height:20px;" >
                                <td align = "left" style = "width:100px;">
                                    &nbsp;
                                    <asp:Label ID="LabelName" runat="server" Text="Name:" AssociatedControlID="NameLabel" SkinID = "DataLabel" ></asp:Label>
                                </td>
                                <td> 
                                    <asp:Label ID="NameLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientName")), false) %>'  SkinID = "DataLabel" />
                                </td>
                            </tr>
                             
                            <tr style = "height:20px;" >
                                <td align = "left" style = "width:125px;">   
                                    &nbsp;
                                    <asp:Label ID="LabelBranch" runat="server" Text="Service Branch:" AssociatedControlID="SBranchLabel" SkinID = "DataLabel" ></asp:Label>
                                </td> 
                                <td>
                                    <asp:Label ID = "SBranchLabel" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientServiceBranch")), false) %>'  SkinID = "DataLabel" />
                                
                                </td>
                              </tr>
                              <tr style = "height:20px;" >
                                    <td align = "left" style = "width:100px;">
                                        &nbsp;
                                        <asp:Label ID="LabelZip" runat="server" Text="Postal Code:" AssociatedControlID="PostalLabel" SkinID = "DataLabel" ></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label ID="PostalLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientZip")), false) %>' SkinID = "DataLabel" />
                                    </td>
                                
                                </tr> 
                              </table> 
                           </td>
                           <td>
                            <table border = "0px">
                                <tr style = "height:20px;" >
                                    <td align = "left" style = "width:100px;">
                                        &nbsp;
                                        <asp:Label ID="LabelSSN" runat="server" Text="SSN:" AssociatedControlID="SSNLabel" SkinID = "DataLabel" ></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label ID="SSNLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientSSN")),false) %>'  SkinID = "DataLabel" />
                                    </td>
                                </tr>
                                <tr style = "height:20px;" >
                                    <td align = "left" style = "width:125px;">
                                        &nbsp;
                                        <asp:Label ID="LabelStatus" runat="server" Text="Service Status:" AssociatedControlID="StatusLabel" SkinID = "DataLabel" ></asp:Label>
                                    </td>
                                    <td> 
                                        <asp:Label ID="StatusLabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientServiceStatus")),false)%>' SkinID = "DataLabel" />
                                    </td>
                                </tr>
                                
                                
                            </table> 
                           </td>
                       </tr>   
                       </table>  
                </asp:Panel>
                <br />                        
            </ItemTemplate>
                <PagerStyle BackColor="#284775" ForeColor="White" HorizontalAlign="Center" />
                <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
                <EditRowStyle BackColor="#999999" />
            </asp:FormView>
            </td> 
        </tr>
        <tr>
            <td>
                <asp:Panel ID="PanelLabRequest" GroupingText="&nbsp;Lab Request&nbsp;" style="width:750px;"  runat="server">
        <br />
            <table align= "left" class="style1" cellpadding = "5" cellspacing = "5" border="0">
            <tr style = "height:20px;" >
                <td class="style3">
                    <asp:Label runat="server" ID="labelSampleType" Text="Sample Type:" SkinID = "DataLabel" AssociatedControlID="lblSampleType" Width="300px"></asp:Label></td>
                <td>
                    <asp:Label ID="lblSampleType" SkinID = "DataLabel" runat="server" Width="115px" ></asp:Label>
                </td>
            </tr>
            
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label runat="server" ID="labelLabRequestNumber" 
                        SkinID = "DataLabel" 
                        Text="Lab Request Number:" 
                        AssociatedControlID="lblLabRequestNumber" 
                        Width="300px">
                    </asp:Label></td>
                <td>
                    <asp:Label ID="lblLabRequestNumber" SkinID = "DataLabel" runat="server" Width="115px" ></asp:Label>
                </td>
            </tr>
         
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label runat="server" ID="LabelLabRequestDate" 
                        Text="Lab Request Date (mm/dd/yyyy):" 
                        AssociatedControlID="LabRequestDate" SkinID = "DataLabel" >
                    </asp:Label></td>
                <td>
                
                    <asp:TextBox ID = "LabRequestDate" runat = "server"/>

                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorLabRequestDate" runat="server" 
                        ControlToValidate="LabRequestDate"
                        EnableClientScript="true"
                        ValidationGroup="LabOrderValidation"
                        ErrorMessage="Lab Request Date is required."
                        SetFocusOnError="true">
                    </asp:RequiredFieldValidator>
                    <asp:RangeValidator ID="RangeValidatorLabRequestDateIsDate" runat="server" 
                        EnableClientScript="true"
                        SetFocusOnError="true"
                        ControlToValidate="LabRequestDate"
                        ValidationGroup="LabOrderValidation"
                        MinimumValue="1/1/1900"
                        Type="Date"
                        ErrorMessage="Lab Request Date must be in format (mm/dd/yyyy) and equal to or earlier than today.">
                    </asp:RangeValidator>
                   
                </td>
            </tr>
            <tr style = "height:20px;">
                <td class="style3">
                    <asp:Label runat="server" ID="LabelSampleReceivedDate" 
                        Text="Date Sample Received<br> at Metals Lab (mm/dd/yyyy):" 
                        AssociatedControlID="LabSampleReceivedDate" SkinID = "DataLabel" >
                    </asp:Label></td>
                <td>
                    <asp:TextBox ID = "LabSampleReceivedDate" runat = "server"/>
                    
                    <asp:RangeValidator ID="RangeValidatorLabelSampleReceivedDateIsDate" runat="server" 
                        EnableClientScript="true"
                        SetFocusOnError="true"
                        ControlToValidate="LabSampleReceivedDate"
                        ValidationGroup="LabOrderValidation"
                        MinimumValue="1/1/1900"
                        Type="Date"
                        ErrorMessage="Date Sample Received at Metals Lab must be equal to or earlier than today.">
                    </asp:RangeValidator>
                    
                    <asp:CompareValidator ID = "CompareValidatorLabSampleReceivedDate" runat = "server" 
                        EnableClientScript="true"
                        SetFocusOnError="true"
                        ControlToValidate = "LabSampleReceivedDate" 
                        ControlToCompare = "LabRequestDate" 
                        Operator = "GreaterThanEqual"  
                        ErrorMessage = "Date Sample Received at Metals Lab must be in the format (mm/dd/yyyy) and be equal or later than Lab Request Date" 
                        Display = "Dynamic"
                        ValidationGroup="LabOrderValidation" 
                        Type = "Date"/> 
                    
                </td>
            </tr>
            <tr style = "height:20px;">
                <td>
                    <asp:Label runat="server" ID="LabelForLabLabelReportDate" 
                        SkinID = "DataLabel" 
                        Text="Metals Lab Report Date:" 
                        AssociatedControlID="LabelLabReportDate" 
                        Width="300px">
                    </asp:Label></td>
                <td>
                    <asp:Label ID="LabelLabReportDate" runat="server" 
                        SkinID = "DataLabel" 
                        Width="115px" >
                    </asp:Label>
                </td>
            </tr>
        </table>
        </asp:Panel>    
           </td>
                
        </tr>
        <tr>
            <td>
                <br />
            </td>
        </tr>
        <tr>
            <td align = "center">
                 <asp:Button runat = "server" ID = "SaveButton" Text = "Save" Width = "130px" OnClick = "SaveButton_Click" />        
                 <asp:Button runat =  "server" Text = "Complete" Width = "130px" ID = "CompleteButton" OnClick = "CompleteButton_Click" ValidationGroup = "LabOrderValidation"/>
                 <asp:Button runat = "server" Text = "Void" Width = "130px" ID = "VoidButton" OnClick = "VoidButton_Click" />
                 <asp:Button runat = "server" Text = "Back" Width = "130px" OnClick = "CancelButton_Click" ID = "CancelButton" UseSubmitBehavior = "false" CssClass = "cancel" />
            </td>            
        </tr>
  </table>       
  <br />
</asp:Content> 